CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	IF EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'v_rc_cli_conv_pbm') THEN 
		DROP VIEW v_rc_cli_conv_pbm;
		RAISE NOTICE 'v_rc_cli_conv_pbm Dropada.';
	END IF;
	
	CREATE VIEW v_rc_cli_conv_pbm 
	AS  SELECT 
				rc_cli.cd_emp,	
				rc_cli.cd_cli,
				rc_cli.rz_cli,
				rc_cli.nm_fant,
				rc_cli_conv.cd_conv,
				rc_cli_conv.ds_conv,
				rc_cli.rot_conv_ext,
				rc_cli.ROT_CONV_EXT_AUTO_PDV
			   FROM rc_cli
				 LEFT JOIN rc_cli_conv ON 
						rc_cli.cd_conv = rc_cli_conv.cd_conv AND 
						rc_cli.cd_emp = rc_cli_conv.cd_emp
				 WHERE rc_cli.sts_cli = 0::numeric and rot_conv_ext > 0;

	ALTER TABLE v_rc_cli_conv_pbm
	  OWNER TO postgres;
		
	RAISE NOTICE 'v_rc_cli_conv_pbm Recriada.';

END; 
-- fim bloco principal versao 12/11/2024
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();